#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>

#include "tcl_interface.h"
#include "namespace.h"
#include "agent.h"
#include "utils.h"
#include "routine.h"

extern ROUTINE *routines;
extern long routines_free;


int routines_num(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(routines_free));
return TCL_OK;
}

int routine_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: routine_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: routine_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=routines_free){
	Tcl_AppendResult(interp,"ERROR: routine_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,routines[i].name,NULL);
return TCL_OK;
}

int routine_comment(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: routine_comment requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: routine_comment: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=routines_free){
	Tcl_AppendResult(interp,"ERROR: routine_comment: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,routines[i].comment,NULL);
return TCL_OK;
}

int routine_type1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: routine_comment requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: routine_comment: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=routines_free){
	Tcl_AppendResult(interp,"ERROR: routine_comment: index too big",NULL);
	return TCL_ERROR;
	}	
switch(routines[i].type & 0xFFFF){
	case ROUTINE_COMPOSITE: 
		Tcl_AppendResult(interp,"composite",NULL);
		break;
	case ROUTINE_BUILTIN: 
		Tcl_AppendResult(interp,"builtin",NULL);
		break;
	case ROUTINE_CUSTOMIZED: 
		Tcl_AppendResult(interp,"customized",NULL);
		break;
	default:
		Tcl_AppendResult(interp,"prototype",NULL);
		break;
	}
return TCL_OK;
}

int find_routine(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_routine requires one argument",NULL);
	return TCL_ERROR;
	}
for(i=0;i<routines_free;i++)
	if(!strcmp(routines[i].name,argv[1])){
		Tcl_SetObjResult(interp,Tcl_NewIntObj(i));
		return TCL_OK;
		}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
return TCL_OK;
}

